unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CPortCtl, CPort, StdCtrls, ComCtrls, ExtCtrls, IniFiles;

type
  TForm1 = class(TForm)
    ComPort: TComPort;
    ComDataPacket1: TComDataPacket;
    Edit1: TEdit;
    Button3: TButton;
    StatusBar1: TStatusBar;
    cb5: TCheckBox;
    cb4: TCheckBox;
    cb3: TCheckBox;
    cb2: TCheckBox;
    cb1: TCheckBox;
    cb0: TCheckBox;
    Label1: TLabel;
    Label3: TLabel;
    Label2: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    cbAuto: TCheckBox;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    Label19: TLabel;
    Label20: TLabel;
    Label21: TLabel;
    Label22: TLabel;
    Panel1: TPanel;
    Button2: TButton;
    ComLed1: TComLed;
    Button1: TButton;
    cbClear: TCheckBox;
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Edit1KeyPress(Sender: TObject; var Key: Char);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure cb0Click(Sender: TObject);
    procedure cb1Click(Sender: TObject);
    procedure cb2Click(Sender: TObject);
    procedure cb3Click(Sender: TObject);
    procedure cb4Click(Sender: TObject);
    procedure cb5Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  BinVal: Byte;

implementation

uses Unit2;

{$R *.dfm}

procedure TForm1.Button2Click(Sender: TObject);
var
  Str: String;
begin
   ComPort.ShowSetupDialog;

   ComPort.StoreSettings(stIniFile, ChangeFileExt(ParamStr(0), '.ini'));

  if not ComPort.Connected then
  begin
    try
      ComPort.Open;
    except
      ShowMessage('Unable to open COM port.');
    end;
  end;
  if ComPort.Connected then
    ComLed1.Kind:= lkGreenLight
  else
   ComLed1.Kind:= lkRedLight;

  Str:= ComPort.Port;
  Statusbar1.SimpleText:= Str;
end;

procedure TForm1.Button3Click(Sender: TObject);
var
  Str: String;
begin

  Str := Edit1.Text;
  if Str = '' then Exit;
  Edit1.SetFocus();
  if StrToInt(Str) > 63 then
  begin
    SystemParametersInfo(SPI_SETBEEP, 1, nil, SPIF_SENDWININICHANGE);
    Beep();
    Exit;
  end;

  ComPort.WriteStr(Str);
  Edit1.Text:= '';
end;

procedure TForm1.Edit1KeyPress(Sender: TObject; var Key: Char);
begin
  if Edit1.Focused and (Key = #13) then
  begin
    Key := #0; // Cancels the keypress
    SystemParametersInfo(SPI_SETBEEP, 0, nil, SPIF_SENDWININICHANGE);
    Button3Click(Self);
    Exit;
  end;
  SystemParametersInfo(SPI_SETBEEP, 1, nil, SPIF_SENDWININICHANGE);
  // #8 is Backspace
  if not (Key in [#8, '0'..'9']) then begin
   Beep();
    // Discard the key
    Key := #0;
  end;

end;

procedure TForm1.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
var
  Ini: TIniFile;
begin
 if cbClear.Checked then
 begin
   ComPort.WriteStr('0');
 end;
 Ini:= TIniFile.Create(ChangeFileExt(ParamStr(0), '.ini'));
 if FileExists(ChangeFileExt(ParamStr(0), '.ini')) then
 begin
   Ini.WriteBool('ComPort', 'Auto', cbAuto.Checked);
   Ini.WriteBool('ComPort', 'Clear', cbClear.Checked);
   ComPort.StoreSettings(stIniFile, ChangeFileExt(ParamStr(0), '.ini'));
 end;
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  Ini: TIniFile;
begin
 BinVal:= 0;
 Ini:= TIniFile.Create(ChangeFileExt(ParamStr(0), '.ini'));
 if FileExists(ChangeFileExt(ParamStr(0), '.ini')) then
 begin
   cbAuto.Checked:= Ini.ReadBool('ComPort', 'Auto',  True);
   cbClear.Checked:= Ini.ReadBool('ComPort', 'Clear', False);
   ComPort.LoadSettings(stIniFile,  ChangeFileExt(ParamStr(0), '.ini'));
   try
     ComPort.Open;
   except
     Showmessage('Unable to open COM port' +#10+#13 + 'Check the Port settings');
   end;

  if ComPort.Connected then
    ComLed1.Kind:= lkGreenLight
  else
   ComLed1.Kind:= lkRedLight;

  Statusbar1.SimpleText:= ComPort.Port;
 end;
end;

procedure TForm1.cb0Click(Sender: TObject);
begin
  if cb0.Checked then
     BinVal:= BinVal + 1
  else
    BinVal:= BinVal - 1;

  Edit1.Text:= IntToStr(BinVal);
  if cbAuto.Checked then
   Button3Click(Self);
end;

procedure TForm1.cb1Click(Sender: TObject);
begin
   if cb1.Checked then
     BinVal:= BinVal + 2
  else
    BinVal:= BinVal - 2;

  Edit1.Text:= IntToStr(BinVal);
  if cbAuto.Checked then
   Button3Click(Self);
end;

procedure TForm1.cb2Click(Sender: TObject);
begin
   if cb2.Checked then
     BinVal:= BinVal + 4
  else
    BinVal:= BinVal - 4;

  Edit1.Text:= IntToStr(BinVal);
  if cbAuto.Checked then
   Button3Click(Self);
end;

procedure TForm1.cb3Click(Sender: TObject);
begin
   if cb3.Checked then
     BinVal:= BinVal + 8
  else
    BinVal:= BinVal - 8;

  Edit1.Text:= IntToStr(BinVal);
  if cbAuto.Checked then
   Button3Click(Self);
end;

procedure TForm1.cb4Click(Sender: TObject);
begin
    if cb4.Checked then
     BinVal:= BinVal + 16
  else
    BinVal:= BinVal - 16;

  Edit1.Text:= IntToStr(BinVal);
  if cbAuto.Checked then
   Button3Click(Self);
end;

procedure TForm1.cb5Click(Sender: TObject);
begin
    if cb5.Checked then
     BinVal:= BinVal + 32
  else
    BinVal:= BinVal - 32;

  Edit1.Text:= IntToStr(BinVal);
  if cbAuto.Checked then
   Button3Click(Self);
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  Form2.left:= Form1.Left-25;
  Form2.Top:= Form1.Top+40;
  Form2.ShowModal;
end;

end.
